/*
Desktop Calendar 1.5 by
Gerald Riechmann <grichman@cs.tu-berlin.de>
http://gerald-riechmann.home.ml.org

Additional programming by
Thomas Riechmann <thomas.riechmann@informatik.uni-erlangen.de>
http://www4.informatik.uni-erlangen.de/~riechmann/

To change fonts, colors and backgrounds, edit one of the files
Desktop Calendar Style User 1.css
Desktop Calendar Style User 2.css
*/


monthName = new Array('Januar', 'Februar', 'Mrz', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember');
cssURLs = new Array('Desktop Calendar Style.css', 'Desktop Calendar Style User 1.css', 'Desktop Calendar Style User 2.css');
var cssURLCookieKey = 'DesktopCalendarCssURL';

function setCookie(name, value, expire) {
   document.cookie = escape(name) + "=" + escape(value) + (expire ? ("; expires=" + expire.toGMTString()) : "");
}

function getCookie(name) {
	var search = escape(name) + "=";
	var offset = document.cookie.indexOf(search);
	if (offset == -1) return '';
	offset += search.length;
	var end = document.cookie.indexOf(";", offset);
	if (end == -1) end = document.cookie.length;
	return unescape(document.cookie.substring(offset, end));
}

function getYearY2K(){
	return (this.getYear() > 1900) ? this.getYear() : this.getYear() + 1900;
}
Date.prototype.getYearY2K = getYearY2K;

function linkOnClick(code){
	return '<A href="" onClick="' + code + ';return false">' + this + '</A>';
}
String.prototype.linkOnClick = linkOnClick;


function atMidnightDo(code){
	var now = new Date();
	var expireTime = new Date(now.getYear(), now.getMonth(), now.getDate() + 1, 0, 0, 1); // next day, 0:00:01
	setTimeout(code, expireTime.getTime() - now.getTime());
}

function openInfo(href){
	window.open(href, 'deskcalInfo',
		'directories=no,menubar=no,location=no,resizable=yes,scrollbars=auto,status=yes,toolbar=no,width=550,height=500');
}

function desktopCalendarCode(monthOffset, cssURL, askUser){
	return('desktopCalendar(' + monthOffset + ", '" + escape(cssURL) + "', " + (askUser || 0) + ')');
}

function desktopCalendar(monthOffset, cssURL, askUser){
	var now = new Date();
	var thisMonth = new Date(now);
	thisMonth.setHours(12);
	thisMonth.setDate(1);
	thisMonth.setMonth(thisMonth.getMonth() + monthOffset);

	cssURL = cssURL ? unescape(cssURL) : getCookie(cssURLCookieKey) || cssURLs[0];
	if(askUser) cssURL = prompt('Specify the Cascading Style Sheets file you would like to open:', cssURL) || cssURL;
	setCookie(cssURLCookieKey, cssURL, new Date(2200, 0, 1));

	var countDate = new Date(thisMonth);
	countDate.setDate(countDate.getDate() - ((countDate.getDay() + 6) % 7)); // Monday

	var calendarRows = '';

	do{
		calendarRows += '<TR class=ThisMonth>';
		for(var dayOfWeek = 1; dayOfWeek <= 7; dayOfWeek++){
			calendarRows += ((countDate.getMonth() != thisMonth.getMonth()) ? '<TD class=OtherMonths>' :
				((!monthOffset) && (countDate.getDate() == now.getDate())) ? '<TD class=Today>' : '<TD>')
				+ countDate.getDate() + '</TD>';
			countDate.setDate(countDate.getDate()+1);
		}
		calendarRows += '</TR>';
	}while(countDate.getMonth() == thisMonth.getMonth());

	document.open("text/html", "replace");
	document.writeln('<HTML>\
	<HEAD>\
		<!--BASE-->\
		<TITLE>Active Desktop Calendar</TITLE>\
		<LINK REL="stylesheet"  TYPE="text/css" HREF="' + escape(cssURL) + '">\n\
		\n\
		<SCRIPT Language="JavaScript" src="Desktop Calendar Script (german).js"></SCRIPT>\n\
	</HEAD>\n\
	<BODY class="Month' + (thisMonth.getMonth()+1) + '" ID="Year' + thisMonth.getYearY2K() + '">\n\
		<TABLE class=OuterFrame>\
			<TR><TD class=OuterFrame id=LeftFrame>\
				<SMALL class=Info>'
				+ '&nbsp;&lt;&lt;'.linkOnClick(desktopCalendarCode(monthOffset-1, cssURL)) + ' '
				+ '&nbsp;+&nbsp;'.linkOnClick(desktopCalendarCode(0, cssURL)) + ' '
				+ '&gt;&gt;&nbsp;'.linkOnClick(desktopCalendarCode(monthOffset+1, cssURL)) + ' '
				+ '&nbsp;'
				+ '&nbsp;&nbsp;'.linkOnClick(desktopCalendarCode(monthOffset, cssURLs[0])) + ' '
				+ '&nbsp;1&nbsp;'.linkOnClick(desktopCalendarCode(monthOffset, cssURLs[1])) + ' '
				+ '&nbsp;2&nbsp;'.linkOnClick(desktopCalendarCode(monthOffset, cssURLs[2])) + ' '
				+ '&nbsp;...&nbsp;'.linkOnClick(desktopCalendarCode(monthOffset, cssURL, 1)) + ' '
				+ '&nbsp;\
				<A onClick="openInfo(this.href); return false" target="_blank" \
				   href="Desktop Calendar Info.html">&nbsp;?&nbsp;</A>\
				\
				<B>Active&nbsp;Desktop&nbsp;Calendar</B>\
				</SMALL>\
				</TD><TD class=OuterFrame id=RightFrame>\
				<TABLE class=Calendar>\
					<TR><TD colspan=2 class=Large id=MonthLarge>' + monthName[thisMonth.getMonth()] + '</TD></TR>\
					<TR><TD class=Large id=YearLarge>' + thisMonth.getYearY2K() + '</TD>\
						<TD><TABLE class=MonthTable>\
							<TR class=WeekdayTitle>\
							<TD>Mo</TD><TD>Di</TD><TD>Mi</TD><TD>Do</TD><TD>Fr</TD><TD>Sa</TD><TD>So</TD></TR>'
							+ calendarRows
						+ '</TABLE></TD>\
					</TR>\
				</TABLE>\
			</TD></TR>\
		</TABLE>\
	</BODY>\
</HTML>');
	document.close();
	atMidnightDo(desktopCalendarCode(0,cssURL));
}
